#include <stdio.h>
#include <stdlib.h>
typedef struct {
    int x, y;
} 
Tacka;

int poredi(const void *a, const void *b) {
    Tacka *p1 = (Tacka *)a, *p2 = (Tacka *)b;
    if (p1->x != p2->x) return p1->x - p2->x;
    return p1->y - p2->y;
}

int krosProizvod(Tacka p, Tacka q, Tacka r) {
    return (q.x - p.x) * (r.y - p.y) - (q.y - p.y) * (r.x - p.x);
}

int p_poli(Tacka *tacke, int n) {
    int P = 0;
    for (int i = 0; i < n; i++) {
        int j = (i + 1) % n;  
        P += tacke[i].x * tacke[j].y - tacke[j].x * tacke[i].y;
    }
    return abs(P) / 2;  
}

int konveksniOmotac(Tacka *tacke, int n, Tacka *omotac) {
    qsort(tacke, n, sizeof(Tacka), poredi);

    int k = 0;

    for (int i = 0; i < n; i++) {
        while (k >= 2 && krosProizvod(omotac[k - 2], omotac[k - 1], tacke[i]) <= 0)
            k--;
        omotac[k++] = tacke[i];
    }


    int t = k + 1;
    for (int i = n - 2; i >= 0; i--) {
        while (k >= t && krosProizvod(omotac[k - 2], omotac[k - 1], tacke[i]) <= 0)
            k--;
        omotac[k++] = tacke[i];
    }
    return k - 1;
}

int main() {
    int N;
    scanf("%d", &N); 
    Tacka tacke[N];  
    for (int i = 0; i < N; i++) {
        scanf("%d %d", &tacke[i].x, &tacke[i].y);  
    }

    Tacka omotac[N];
    int vel_omot = konveksniOmotac(tacke, N, omotac);
    int MinP = 2147483647; 

    for (int i = 0; i < N; i++) {
        Tacka Priv_tack[N-1];
        int k = 0;
        for (int j = 0; j < N; j++) {
            if (i != j) {
                Priv_tack[k++] = tacke[j];
            }
        }

        Tacka nv_omot[N];
        int nv_vel_omot = konveksniOmotac(Priv_tack, N-1, nv_omot);
        int P = p_poli(nv_omot, nv_vel_omot);
        

        if (P < MinP) {
            MinP = P;
        }
    }


    printf("%d\n", MinP);
    return 0;
}